<?xml version="1.0"?>
<!-- Written by Peter Mertens "peter@pmertens.de" -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template match="/Kundendaten">
		<xsl:processing-instruction name="cocoon-format">type="text/html"</xsl:processing-instruction>
		<html>
			<head>
				<title>
Verdichtete Kundenumsatzdaten</title>
			</head>
			<body bgcolor="#C0C0C0">
				<h3 align="center">
					<font color="#FF0000">
    Name: <xsl:value-of select="Nachname"/>, <xsl:value-of select="Vorname"/>, Kundennummer: <xsl:value-of select="Kundennummer"/>
					</font>
				</h3>
				<h4>Stichtag: <xsl:value-of select="@Stichtag"/>
				</h4>
				<xsl:apply-templates select="Konto">
					<xsl:sort select="Kontoart"/>
					<xsl:sort select="Kontonummer"/>
				</xsl:apply-templates>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="Konto">
		<h4>
			<font color="#FF0000">Kontoart: <xsl:value-of select="Kontoart"/>, Kontonummer: <xsl:value-of select="Kontonummer"/>
			</font>
		</h4>
		<xsl:if test='Umsaetze!=""'>
			<table bgcolor="#C0C0C0" cellpadding="0" border="0" width="100%" cellspacing="10">
				<xsl:apply-templates select="Umsaetze"/>
			</table>
		</xsl:if>
	</xsl:template>
	<xsl:template match="Umsaetze">
		<xsl:if test="position()=1">
			<font color="#FF0000">verdichtete Umsatzdaten:</font>
			<tr>
				<td valign="top">
					<font color="#FF0000">Stichtag</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Haben-Gesamtumsaetze</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Anzahl-Haben-Umsaetze</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Soll-Gesamtumsaetze</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Anzahl-Soll-Umsaetze</font>
				</td>
			</tr>
		</xsl:if>
		<tr>
			<td valign="top">
				<xsl:value-of select="Stichtag"/>
			</td>
			<td valign="top">
				<xsl:value-of select="format-number(Haben-Gesamtumsaetze,'##,##0.00')"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Anzahl-Haben-Umsaetze"/>
			</td>
			<td valign="top">
				<xsl:value-of select="format-number(Soll-Gesamtumsaetze,'##,##0.00')"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Anzahl-Soll-Umsaetze"/>
			</td>
		</tr>
		<xsl:if test="position()=last()">
			<tr>
				<td valign="top">
					<font color="#FF0000">durchschnittlich</font>
				</td>
				<td valign="top">
					<xsl:value-of select="format-number(sum(../Umsaetze/Haben-Gesamtumsaetze) div count(../Umsaetze/Haben-Gesamtumsaetze),'##,##0.##')"/>
				</td>
				<td valign="top">
					<xsl:value-of select="format-number(sum(../Umsaetze/Anzahl-Haben-Umsaetze) div count(../Umsaetze/Anzahl-Haben-Umsaetze),'##,##0.##')"/>
				</td>
				<td valign="top">
					<xsl:value-of select="format-number(sum(../Umsaetze/Soll-Gesamtumsaetze) div count(../Umsaetze/Soll-Gesamtumsaetze),'##,##0.##')"/>
				</td>
				<td valign="top">
					<xsl:value-of select="format-number(sum(../Umsaetze/Anzahl-Soll-Umsaetze) div count(../Umsaetze/Anzahl-Soll-Umsaetze),'##,##0.##')"/>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
